/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.ProblemAnalysisException;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;

public class JournaledProblem
extends CommonProblem
implements Persistable {
    private static final String TRACE_MASKT = "XPAJPROT";
    private static final String TRACE_MASKF = "XPAJPROF";
    private static final String TRACE_MASKD = "XPAJPROD";
    private static final String BUILDTRACE = "BUILD_STRING";
    private static final boolean UNIT_TEST = true;

    public JournaledProblem() {
        this("Journaled Problem");
        Trace.trace(TRACE_MASKD, "<--> JournaledProblem.ctor(V1.1)");
    }

    public JournaledProblem(String description) {
        super(description);
    }

    public JournaledProblem(PersistentData data) throws PersistenceException {
        super(((JournaledProblemPersistentData)data).superClassPersistentData);
    }

    public PersistentData getPersistentData() {
        JournaledProblemPersistentData persistentData = new JournaledProblemPersistentData();
        persistentData.superClassPersistentData = super.getPersistentData();
        return persistentData;
    }

    public void setProblemState(int problemState) {
        Trace.trace(TRACE_MASKF, "set the problem state to be" + problemState);
        super.setProblemState(problemState);
        if (problemState == 1 && this.problemNumber != Integer.MIN_VALUE) {
            Trace.trace(TRACE_MASKD, "cut the log entry here");
            StringBuffer sb = new StringBuffer(500);
            XMLHelper.outToXML(this, sb, this.getClass());
            byte[] paLogData = sb.toString().getBytes();
            Trace.trace(TRACE_MASKD, "problem opened");
            Trace.trace(TRACE_MASKD, "add the f2 block to the data");
            String f2String = new String(this.getRefcode() + " " + this.getExtension());
            Trace.trace(TRACE_MASKD, "the data is >" + f2String + "<");
            Log theLog = new Log(11, 20, 0, "PA Results", null, null, null, f2String);
            theLog.add((byte)3, paLogData);
            theLog.log();
        }
    }

    public void setDuplicateOf(String serviveableEventUniqueKey, int problemNumber) {
        super.setDuplicateOfProblemNumber(serviveableEventUniqueKey, problemNumber);
        String displayText = null;
        if (problemNumber != Integer.MIN_VALUE) {
            displayText = "of_Problem_" + Integer.toString(problemNumber) + " ";
        }
        Log theLog = new Log(-86, 70, 0, "PA EVT DUP", null, null, null, displayText);
        theLog.add((byte)3, serviveableEventUniqueKey);
        theLog.log();
    }

    public void serviceHistoryEvent(HistoryEntry event) throws ProblemAnalysisException {
        Trace.trace(TRACE_MASKF, "--> servicedHistoryEntry()");
        Trace.trace(TRACE_MASKD, "key is = " + this.getUniqueKey());
        Trace.trace(TRACE_MASKD, "problem number is = " + this.problemNumber);
        byte[] header1 = this.getUniqueKey().getBytes();
        byte[] header2 = new String("::").getBytes();
        byte[] header3 = new Integer(this.problemNumber).toString().getBytes();
        int logLength = header1.length + header2.length + header3.length;
        byte[] logData = new byte[logLength];
        int copyLength = 0;
        System.arraycopy(header1, 0, logData, 0, header1.length);
        System.arraycopy(header2, 0, logData, copyLength += header1.length, header2.length);
        System.arraycopy(header3, 0, logData, copyLength += header2.length, header3.length);
        Trace.trace(TRACE_MASKD, "log data is *************");
        Trace.trace(TRACE_MASKD, logData);
        try {
            Trace.trace(TRACE_MASKT, "log the sh data");
            Log theLog = new Log(11, 17, 0, this.getShString(event), null, null, null, null);
            theLog.add((byte)3, logData);
            theLog.log();
            Trace.trace(TRACE_MASKD, "call the super method");
            super.serviceHistoryEvent(event);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "exception logging the service history data");
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKF, "<-- servicedHistoryEntry");
    }

    String getShString(HistoryEntry entry) {
        switch ((byte)entry.getHistory()) {
            case 1: {
                return "SHProbOpen";
            }
            case 11: {
                return "SHReopened";
            }
            case 2: {
                return "SHCustReport";
            }
            case 13: {
                return "SHAuthViaRSF";
            }
            case 14: {
                return "SHAuthDealyed";
            }
            case 15: {
                return "SHAuthbyPhon";
            }
            case 16: {
                return "SHServNotReq";
            }
            case 3: {
                return "SHRSFComplet";
            }
            case 17: {
                return "SHRSFFailure";
            }
            case 18: {
                return "SHRSFCancel";
            }
            case 19: {
                return "SH_RVCancel";
            }
            case 4: {
                return "SH_RVStart";
            }
            case 12: {
                return "SH_RVNwData";
            }
            case 5: {
                return "SH_RVSuspnd";
            }
            case 6: {
                return "SH_RVRpToHrd";
            }
            case 7: {
                return "SH_RVRpFrHrd";
            }
            case 8: {
                return "SH_RVResume";
            }
            case 9: {
                return "SH_RVEnd";
            }
            case 32: {
                return "SH_RVClose";
            }
            case 33: {
                return "SHClosByUser";
            }
            case 34: {
                return "SHCloseInact";
            }
            case 35: {
                return "SHDupClosed";
            }
            case 36: {
                return "SHClosNonRep";
            }
            case 20: {
                return "SHRSFNoMsg";
            }
            case 21: {
                return "SHRSFNoFix";
            }
            case 22: {
                return "SHRSFServFix";
            }
            case 23: {
                return "SHRSFCallFix";
            }
        }
        return "XSH";
    }

    private static class JournaledProblemPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public PersistentData superClassPersistentData = null;
        public int version = 1;

        private JournaledProblemPersistentData() {
        }
    }
}

